/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.planning.mokos;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.io.ByteStreams;
import cz.insophy.inplan.planning.PlanningRunner;
import cz.insophy.inplan.planning.algorithms.RebuildPlannerUtils;
import cz.insophy.inplan.planning.mokos.Scheduler;
import cz.insophy.inplan.shop.ShopConfiguration;
import cz.insophy.inplan.superplan.Superplan;
import cz.insophy.inplan.validation.PlanNotValidException;
import cz.insophy.inplan.validation.ValidationResult;
import cz.insophy.inplan.xml.InvalidXmlException;
import cz.insophy.inplan.xml.ShopSerializationException;
import cz.insophy.inplan.xml.ShopSerializer;
import cz.insophy.inplan.xml.SuperplanSerializationException;
import cz.insophy.inplan.xml.SuperplanSerializer;
import cz.insophy.inplan.xml.XmlSource;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class MokosRunner
extends PlanningRunner<Scheduler> {
    private static final Logger log = LoggerFactory.getLogger(MokosRunner.class);
    public static final String DEFAULT_USER_XML = Joiner.on(File.separatorChar).join(System.getProperty("user.home"), ".inplan", "mokos-config.xml");
    public static final ClassPathResource DEFAULT_MOKOS_CONFIG_RESOURCE = new ClassPathResource("default-config.xml", MokosRunner.class);
    private GenericApplicationContext context;
    private boolean useDefaultConfig;
    private File configurationFile;
    private Resource configurationResource;
    private ClassLoader classLoader;

    @Override
    @Nonnull
    protected Scheduler createPlanningAlgorithm() {
        Scheduler scheduler;
        if (this.context == null) {
            DefaultListableBeanFactory beanFactory = new DefaultListableBeanFactory();
            beanFactory.registerSingleton("superplan", (Object)this.getSuperplan());
            this.context = new GenericApplicationContext(beanFactory);
            XmlBeanDefinitionReader reader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)this.context);
            if (this.classLoader != null) {
                reader.setBeanClassLoader(this.classLoader);
            }
            Resource xml = this.getConfigurationXmlResource();
            reader.loadBeanDefinitions(xml);
            this.context.refresh();
            scheduler = (Scheduler)this.context.getBean(Scheduler.class);
            Preconditions.checkNotNull(scheduler, "No scheduler found in mokos configuration XML.");
            scheduler.afterPropertiesSet();
            log.info("Loaded MoKoS configuration from: " + xml.getDescription());
        } else {
            scheduler = (Scheduler)this.context.getBean(Scheduler.class);
        }
        return scheduler;
    }

    private Resource getConfigurationXmlResource() {
        ClassPathResource res = null;
        Class<MokosRunner> cls = MokosRunner.class;
        if (this.isUseDefaultConfig()) {
            res = new ClassPathResource("default-config.xml", cls);
        } else if (this.configurationFile != null) {
            res = new FileSystemResource(this.configurationFile);
        } else if (this.configurationResource != null) {
            res = this.configurationResource;
        } else {
            List<AbstractResource> possible = Arrays.asList(new FileSystemResource(DEFAULT_USER_XML), new ClassPathResource("config.xml", cls), DEFAULT_MOKOS_CONFIG_RESOURCE);
            for (Resource resource : possible) {
                if (!resource.exists()) continue;
                res = resource;
                break;
            }
        }
        Preconditions.checkState(res != null && res.exists(), "Cannot find requested configuration %s.", (Object)res);
        return res;
    }

    public void setConfigurationFile(File configurationFile) {
        Preconditions.checkArgument(configurationFile == null || configurationFile.canRead(), "MoKoS configuration file %s is not readable.", (Object)configurationFile);
        this.configurationFile = configurationFile;
    }

    public File getConfigurationFile() {
        return this.configurationFile;
    }

    public void setConfigurationResource(Resource resource) {
        Preconditions.checkArgument(resource.exists(), "MoKoS configuration resource %s doesn't exist.", (Object)resource);
        this.configurationResource = resource;
    }

    public Resource getConfigurationResource() {
        return this.configurationResource;
    }

    @Override
    public void doRun() {
        try {
            Scheduler scheduler = (Scheduler)this.getPlanningAlgorithm();
            Preconditions.checkState(this.context.isActive(), "MokosRunner can be used only once for one run of the planning algorithm.");
            scheduler.schedule();
            RebuildPlannerUtils.fixAndRegister(this.superplan.getPlan());
            this.superplan.invalidateSDGraph();
        }
        finally {
            if (this.context != null) {
                this.context.close();
            }
        }
    }

    @Override
    protected ValidationResult validate(Superplan superplan) {
        return new ValidationResult();
    }

    protected void setUseDefaultConfig(boolean useDefaultConfig) {
        this.useDefaultConfig = useDefaultConfig;
    }

    protected boolean isUseDefaultConfig() {
        return this.useDefaultConfig;
    }

    public boolean writeSetupZip() {
        try {
            File f = File.createTempFile("mokos-session-", ".zip");
            try (ZipOutputStream z = new ZipOutputStream(new FileOutputStream(f));){
                z.putNextEntry(new ZipEntry("mokos-config.xml"));
                try (InputStream mcs = this.configurationResource.getInputStream();){
                    ByteStreams.copy(mcs, z);
                }
                z.closeEntry();
                z.putNextEntry(new ZipEntry("conf.xml"));
                ShopSerializer.storeToXml(this.superplan.getShopConf(), z);
                z.closeEntry();
                z.putNextEntry(new ZipEntry("plan.xml"));
                SuperplanSerializer.storeToXml(this.superplan, z);
                z.closeEntry();
            }
            log.info("Wrote MoKoS planning setup to {}.", (Object)f);
            return true;
        }
        catch (ShopSerializationException | SuperplanSerializationException | IOException e) {
            log.error("Failed to write MoKoS planning setup.", e);
            return false;
        }
    }

    public boolean loadSetupZip(InputStream is) throws IOException {
        int okCnt = 0;
        try (ZipInputStream z = new ZipInputStream(is);){
            ZipEntry entry;
            ShopConfiguration conf = null;
            block17: while ((entry = z.getNextEntry()) != null) {
                log.info("Loading {}...", (Object)entry.getName());
                switch (entry.getName()) {
                    case "mokos-config.xml": {
                        this.setConfigurationResource((Resource)new ByteArrayResource(ByteStreams.toByteArray(z), "mokos-config.xml from zip"));
                        ++okCnt;
                        continue block17;
                    }
                    case "conf.xml": {
                        conf = ShopSerializer.loadFromXml(ByteStreams.toByteArray(z));
                        ++okCnt;
                        continue block17;
                    }
                    case "plan.xml": {
                        Preconditions.checkState(conf != null);
                        this.setSuperplan(SuperplanSerializer.loadFromXml(XmlSource.create(ByteStreams.toByteArray(z)), conf, true));
                        ++okCnt;
                        continue block17;
                    }
                }
                log.warn("Unknown zip entry {}", (Object)entry);
            }
        }
        catch (PlanNotValidException | InvalidXmlException | SuperplanSerializationException e) {
            log.error("Cannot load configuration or plan.", e);
        }
        return okCnt == 3;
    }

    public boolean loadSetupZip(String filename) {
        block8: {
            boolean bl;
            FileInputStream is = new FileInputStream(filename);
            try {
                bl = this.loadSetupZip(is);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (FileNotFoundException e) {
                    log.error("File {} not found.", (Object)filename);
                    break block8;
                }
                catch (IOException e) {
                    log.error("Cannot load runner setup.", e);
                }
            }
            ((InputStream)is).close();
            return bl;
        }
        return false;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }
}

